<?php
// Funkcja wyszukujca nieprawidowo napisane sowa i oferujca list zamiennikw.
function spellcheck_string($str) {
    // Zainicjowanie biblioteki pspell i ustawienie jzyka na polski.
    $dict = pspell_new('pl');

    // Pobieranie poszczeglnych sw w cigu identyfikowanych przez pozycj.
    $words = str_word_count($str, 2);
    
    // Odwrcenie sw, aby mona je byo przetwarza w odwrotnej kolejnoci  od koca do pocztku.
    $rwords = array_reverse($words, true);
    foreach ($rwords as $pos => $word) {
        // Jeli sowo NIE jest napisane poprawnie.
        if (!(pspell_check($dict, $word))) {
            // Wyznaczenie listy sugestii:
            $suggestions = pspell_suggest($dict, $word);

            // Wygenerowanie rozwijanej listy ze sowem i wszystkimi sugestiami:
            $list = '<select name=\"position[{$pos}]\">';
            $list .= "<option value=\"{$word}\">{$word}</option>";
            foreach ($suggestions as $s) {
                $list .= "<option value=\"{$s}\">{$s}</option>";
            }
            $list .= '</select>';
            
            // Wstawienie wybranej sugestii w pocztkowym cigu znakw, 
            //  w  miejscu, gdzie znajdowaa si wczeniejsza wersja sowa.
            $str = substr_replace($str, $list, $pos, strlen($word));
        }
    }

    // Zwrcenie cigu otoczonego znacznikami formularza.
    echo "<form>{$str}</form>";
}

$test_string = "Moja ortografia nie jest naljepsza.  Czsto popelniam rune bledy w zdaniach.";

// Po sprawdzeniu pisowni tekstu uzyskamy wynik podobny do pokazanego poniej:
// Moja ortografia nie jest [naljepsza].  Czsto [popelniam] [rune] [bledy] 
// w zdaniach.
spellcheck_string($test_string);
?>
